﻿using System;
using System.Xml.Serialization;
using System.Collections.Generic;
namespace VdcCommon.BusinessEntities
{
	
    public partial class VDSGroup
	{
		public VDSGroup()
		{
            selection_algorithm = VdsSelectionAlgorithm.None;
            high_utilization = -1;
            low_utilization = -1;
            cpu_over_commit_duration_minutes = -1;
            hypervisor_type = HypervisorType.KVM;
			compatibility_version = new Version("2.1");
		}

		public VDSGroup(System.String name, System.String description, string cpu_name)
			: this()
		{
			this.name = name;
			this.description = description;
			this.cpu_name = cpu_name;
		}

		#region IVdcQueryable Members

        [XmlIgnoreAttribute]
		public override object QueryableId
		{
			get { return ID; }
		}

		private static readonly List<string> _vmProperties = new List<string> { "name", "description", "cpu_name", "cpu_over_commit_duration_minutes", "low_utilization", "high_utilization", "selection_algorithm", "max_vds_memory_over_commit", "storage_pool_id", "compatibility_version", "TransparentHugepages", "MigrateOnError" };
        [XmlIgnoreAttribute]
		public override List<string> ChangeablePropertiesList
		{
			get { return _vmProperties; }
		}

		#endregion

		}
}

